//---------------------------------------------------------------
// Fichero:  grafico1.asy
// Objetivo: Representar el gráfico 1
// Fecha:    D.20.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los cinco vectores
pair a=(8,4), c=(-6,6);
pair a1=(1/4)*a, c1=(-1/3)*c;
pair suma=a1+c1;

// Dimensiones de los ejes
real Xmin = -7, Xmax = 8, Ymin = -3, Ymax = 6, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw(a1 -- suma, Punteado+gray);
draw(c1 -- suma, Punteado+gray);

// Los vectores
draw((0,0)--a, 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--a1, 0.75bp+orange,Arrow(HookHead,5pt));
draw((0,0)--c, 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--c1, 1.5bp+orange,Arrow(HookHead,5pt));
draw((0,0)--suma, 1.5bp+deepred,Arrow(HookHead,5pt));
dot((0,0), 3bp+deepgreen);

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$\frac{1}{4}\vec{a}-\frac{1}{3}\vec{c}$",suma,2SE,FormatoTexto);
label("$\vec{a}$",a,NE,FormatoTexto);
label("$\frac{1}{4}\vec{a}$",a1,N,FormatoTexto);
label("$\vec{c}$",c,NW,FormatoTexto);
label("$-\frac{1}{3}\vec{c}$",c1,S,FormatoTexto);
