//---------------------------------------------------------------
// Fichero:  grafico2.asy
// Objetivo: Representar el gráfico 2
// Fecha:    D.20.4.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Dimensiones de los ejes
real Xmin = -6, Xmax = 6, Ymin = -6, Ymax = 2, Extra = 0.5;

// Formato de marcas los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(5pt);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra));

// Líneas auxiliares
pen Punteado = linetype(new real[] {2,2});
draw((-4,-4) -- (-6,-2), Punteado+gray);
draw((-2,2) -- (-6,-2), Punteado+gray);

// Los vectores
draw((0,0)--(6,-6), 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--(-2,2), 1.5bp+orange,Arrow(HookHead,5pt));
draw((0,0)--(-2,-2), 1.5bp+deepgreen,Arrow(HookHead,5pt));
draw((0,0)--(-4,-4), 0.75bp+orange,Arrow(HookHead,5pt));
draw((0,0)--(-6,-2), 1.5bp+deepred,Arrow(HookHead,5pt));
dot((0,0), 3bp+deepgreen);

// Los nombres de los vectores
pen FormatoTexto = blue+fontsize(8pt);
label("$2\vec{m}-\frac{1}{3}\vec{e}$",(-6,-2),S,FormatoTexto);
label("$\vec{e}$",(6,-6),E,FormatoTexto);
label("$-\frac{1}{3}\vec{e}$",(-2,2),N,FormatoTexto);
label("$\vec{m}$",(-2,-2),SE,FormatoTexto);
label("$2\vec{m}$",(-4,-4),S,FormatoTexto);
