//---------------------------------------------------------------
// Fichero:  xsobrey.asy
// Objetivo: Ilustrar la recta de regresión de X sobre Y
// Fecha:    L.28.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 9, Ymin = 0, Ymax = 5, Extra = 0.5;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra),gray);
draw((Xmin-Extra,0) -- (Xmax+Extra,0),gray);

// Definimos los puntos
pair[] P={(2,2),(4,1),(6,4),(8,3)};

// Número de datos
int n=P.length;

// Las sumas estadisticas
real SumaX=0, SumaY=0, SumaY2=0, SumaXY=0;
for ( int i=0 ; i<n ; ++i )
    {
    SumaX += P[i].x;
    SumaY += P[i].y;
    SumaY2 += (P[i].y)^2;
    SumaXY += (P[i].x)*(P[i].y);
    }

// El centro de gravedad
real MediaX=SumaX/n;
real MediaY=SumaY/n;
pair CG=(MediaX,MediaY);

// El coeficiente de regresión
real CR=(SumaY2/n-MediaY^2)/(SumaXY/n-MediaX*MediaY);

// La recta de regresión
pair V=unit((1,CR)), A=CG-3V, B=CG+3V;
path RR=A -- B;
draw(RR,blue);

// Dibujamos los puntos y las distancias
pair Q;
for ( int i=0 ; i<n ; ++i )
    {
    Q=intersectionpoint(RR,(Xmin,P[i].y)--(Xmax,P[i].y));
    draw(P[i]--Q,red);
    dot(P[i],3bp+deepgreen);
    dot(Q,2bp+blue);
    }

