//---------------------------------------------------------------
// Fichero:  centrogravedad.asy
// Objetivo: Ilustrar el centro de gravedad común
// Fecha:    L.28.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 9, Ymin = 0, Ymax = 5, Extra = 0.5;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra),gray);
draw((Xmin-Extra,0) -- (Xmax+Extra,0),gray);

// Definimos los puntos
pair[] P={(2,2),(4,1),(6,4),(8,3)};

// Número de datos
int n=P.length;

// Las sumas estadisticas
real SumaX=0, SumaY=0, SumaX2=0, SumaY2=0, SumaXY=0;
for ( int i=0 ; i<n ; ++i )
    {
    SumaX += P[i].x;
    SumaY += P[i].y;
    SumaX2 += (P[i].x)^2;
    SumaY2 += (P[i].y)^2;
    SumaXY += (P[i].x)*(P[i].y);
    }

// El centro de gravedad
real MediaX=SumaX/n;
real MediaY=SumaY/n;
pair CG=(MediaX,MediaY);

// Una recta de regresión
real CR=(SumaXY/n-MediaX*MediaY)/(SumaX2/n-MediaX^2);
pair V=unit((1,CR)), A=CG-4V, B=CG+4V;
path RR=A -- B;
draw(RR);

// La otra recta de regresión
real CR=(SumaY2/n-MediaY^2)/(SumaXY/n-MediaX*MediaY);
pair V=unit((1,CR)), A=CG-3V, B=CG+3V;
path RR=A -- B;
draw(RR,blue);

// Dibujamos los puntos
for ( int i=0 ; i<n ; ++i )
    { dot(P[i],3bp+deepgreen); }

// El centro de gravedad
filldraw(circle(CG,0.1),white,gray);
