//---------------------------------------------------------------
// Fichero:  grafica3.asy
// Objetivo: Mostrar la gráfica 3
// Fecha:    S.12.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// fontsize()
import fontsize;

// grid3()
import grid3;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(5.8cm);

// Definición de los valores
int[] V={45,32,21,4,1,0, 21,57,47,17,3,1, 16,43,82,29,7,4, 10,21,65,59,12,7,
         7,15,12,37,23,8, 0,2,3,6,8,16};

// Los nombres del eje de abscisas
string[] NombreX={"150","160","170","180","190", "200", "210"};

// Los nombres del eje de ordenadas
string[] NombreY={"40","55","70","85","100","115","130"};

// Grosor de las líneas
defaultpen(0.5);

// Visión tridimensional
currentprojection=orthographic(-7,-11,5);
limits((0,0,0),(60,60,85));

// El formato del texto
pen FormatoTexto=black+fontsize(6pt);

// La rejilla tridimensional
grid3(new grid3routines[] {XYXgrid, ZXgrid(60.5), ZYgrid(60.5)},
      Step=10,
      pGrid=new pen[] {black, lightgray, lightgray},
      pgrid=new pen[] {lightgray, lightgray, lightgray});

// Los nombres de las variables
label("Altura",(35,-25,0),FormatoTexto);
label("Masa",(-25,35,0),FormatoTexto);

// Los extremos de los intervalos
for (int i=0 ; i<7 ; ++i )
    {
    label(NombreX[i],(10*i,-10,0),FormatoTexto);
    label(NombreY[i],(-7.5,10*i-5,0),FormatoTexto);
    }

// Los valores
for ( int i=1 ; i<=6 ; ++i ) {
for ( int j=1 ; j<=6 ; ++j ) {
    draw(shift(10*i-6,10*j-6,0)*zscale3(V[6*(j-1)+i-1])*unitcube,
         green+opacity(0.5),green,nolight);
    draw(shift((10*i-6,10*j-6,V[6*(j-1)+i-1]))*unitsquare3,0.75bp+deepgreen);
    }}
