//---------------------------------------------------------------
// Fichero:  cc-medio.asy
// Objetivo: Nube de puntos con correlación media
// Fecha:    M.29.7.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Dimensiones de los ejes
real Xmin = 0, Xmax = 10, Ymin = 0, Ymax = 6, Extra = 0.5;

// Grosor de las líneas
defaultpen(1);

// Los ejes
draw((0,Ymin-Extra) -- (0,Ymax+Extra));
draw((Xmin-Extra,0) -- (Xmax+Extra,0));

// Iniciamos el generador de números aleatorios
srand(1);

// Generamos los puntos
real x, y, var;
pair[] P;
for ( int i=0 ; i<19 ; ++i )
    {
    // La abscisa
    x=(i/2+1)+0.3*(unitrand()-0.5);

    // La ordenada
    var=4*unitrand() * (unitrand()>0.5 ? 1 : -1);
    y=0.1*(i/2)+2+var;
    if ( y<0 )  { y=-y; }
    if ( y>Ymax )  { y-=1; }

    // El punto
    P[i]=(x,y);
    dot(P[i],3bp+blue);
    }

// Número de datos
int n=P.length;

// Las sumas estadisticas
real SumaX=0, SumaY=0, SumaX2=0, SumaY2=0, SumaXY=0;
for ( int i=0 ; i<n ; ++i )
    {
    SumaX += P[i].x;
    SumaY += P[i].y;
    SumaX2 += (P[i].x)^2;
    SumaY2 += (P[i].y)^2;
    SumaXY += (P[i].x)*(P[i].y);
    }

// El coeficiente de correlación con dos decimales
real MediaX=SumaX/n;
real MediaY=SumaY/n;
real Covarianza=SumaXY/n-MediaX*MediaY;
real Coeficiente=Covarianza/sqrt((SumaX2/n-MediaX^2)*(SumaY2/n-MediaY^2));
int Redondeado=round(100*Coeficiente);
Coeficiente=Redondeado/100;
string Texto=format("%#.2f", Coeficiente);
//label(Texto,(Xmax+Extra,0.5),align=left,fontsize(10pt));
