//---------------------------------------------------------------
// Fichero:  resolucion2n.asy
// Objetivo: Mostrar la segunda ilustración de la resolución 2
// Fecha:    J.7.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// La circunferencia circunscrita
real r=sqrt(3)/3;
pair T=(0,r/2);
draw(circle((0,r/2),r),gray);

// Definición de los vértices
pair A=(-0.5,0), B=(0.5,0), C=(0,sqrt(3)/2);

// Los radios
draw(T--A,blue);
draw(T--B,blue);
draw(T--C,blue);

// El triangulo
draw(A -- B -- C -- cycle);

// Los nombres
label("$a$",(0,0),S);
label("$a$",(B+C)/2,E);
label("$a$",(A+C)/2,W);
label("$r$",(A+T)/2,NNW);
label("$r$",(B+T)/2,SW);
label("$r$",(C+T)/2,SE);

// El centro
dot(T,3bp+blue);
