//---------------------------------------------------------------
// Fichero:  cubo.asy
// Objetivo: Representar un cubo y su diagonal
// Fecha:    X.28.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// unitcube
import solids;

// Obtendremos un archivo SVG
settings.outformat="png";

// Tamaño de la imagen
size(30cm);

// Proyección
currentprojection=orthographic(5,4,2);

// El cubo
draw(unitcube,gray+opacity(.3),black+4bp);

// La diagonal
draw((1,0,0)--(0,1,1),4bp+red);

// La diagonal de la base
draw((1,0,0)--(0,1,0),4bp+blue);

// Los textos
pen Formato=Bookman(series="m",shape="it")+fontsize(96pt);
label("a",(1,0.5,0),2W+1.5S,Formato);
label("a",(0.5,1,0),S,Formato);
label("a",(0,1,0.5),E,Formato);
label("b",(0.5,0.5,0),N,Formato);
label("d",(1,0.5,0.5),N,Formato);
