//---------------------------------------------------------------
// Fichero:  cuadrado.asy
// Objetivo: Representar un cuadrado y su diagonal
// Fecha:    X.28.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Marcamos un ángulo recto
markrightangle((2,2), (2,0), (0,0), 4mm, 0.5bp+blue);

// El cuadrado
draw((0,0) -- (0,2) -- (2,2) -- (2,0) -- cycle);

// La diagonal
draw((0,0)--(2,2));

// Los textos
pen Formato=Bookman(series="m",shape="it");
label("a",(1,0),S,Formato);
label("a",(2,1),E,Formato);
label("a",(1,2),N,Formato);
label("a",(0,1),W,Formato);
label("d",(1,1),NW,Formato);
