//---------------------------------------------------------------
// Fichero:  semirrecta1a.asy
// Objetivo: Representar la semirrecta (a,→) de la primera forma
// Fecha:    V.23.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1.5);

// El eje de abscisas
draw((0,0) -- (4,0));

// Los puntos
pair A=(0.5,0);
pair B=(3.5,0);

// El extremo
pen FormatoMarca=Helvetica(series="b",shape="n");
label("(",A,FormatoMarca);

// La letra
pen FormatoTexto=fontsize(10pt)+black+Helvetica(series="m",shape="n");
label("a",A,3S,FormatoTexto);

// La flecha
pen FormatoFlecha=fontsize(14pt)+blue;
label("$\longrightarrow$",B,2N+E,FormatoFlecha);

// Marcamos el intervalo
for (int i=0 ; i<17 ; ++i)
    { draw((0.6+0.2*i,-0.075)--(0.8+0.2*i,0.075),1bp+blue); }
