//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Representar el ejemplo 1
// Fecha:    V.23.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1.5);

// El eje de abscisas
draw((0,0) -- (4,0));

// Los puntos
pair A=(0.5,0);
pair B=(3.5,0);

// Las marcas
pen FormatoMarca=Helvetica(series="b",shape="n");
label("(",A,FormatoMarca);
label("]",B,FormatoMarca);

// Las explicaciones
pen FormatoTexto=fontsize(10pt)+blue+Helvetica(series="m",shape="n");
label("abierto",A,2S,FormatoTexto);
label("cerrado",B,2S,FormatoTexto);

// Las flechas
pen FormatoFlecha=fontsize(14pt)+blue;
label("$\longrightarrow$",A,NE,FormatoFlecha);
label("$\longleftarrow$",B,NW,FormatoFlecha);
