//---------------------------------------------------------------
// Fichero:  ejemplo3.asy
// Objetivo: Mostrar el ejemplo 3
// Fecha:    J.22.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Una elipse
path Elipse=scale(3,2)*unitcircle;
filldraw(Elipse,gray,black);

// La repetimos más pequeña
Elipse=scale(0.25)*Elipse;
path[] Replica;
real Hor=1, Ver=0.75;
Replica[0]=shift(Hor,Ver)*Elipse;
Replica[1]=shift(Hor,-Ver)*Elipse;
Replica[2]=shift(-Hor,Ver)*Elipse;
Replica[3]=shift(-Hor,-Ver)*Elipse;

// Dibujamos las réplicas
for (int i=0 ; i<4 ; ++i)
    { filldraw(Replica[i],white,black); }
