//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Representar la resolución 2
// Fecha:    M.13.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Las raíces
real Raiz5=sqrt(5);
real Raiz6=sqrt(6);

// Los ejes de coordenadas
draw((0,0) -- (Raiz6+0.2,0));
draw((0,0) -- (0,1.1));

// El ángulo recto
markrightangle((Raiz5,1), (Raiz5,0), (0,0), 3mm, 0.5bp+gray);

// Líneas auxiliares
draw((0,0)--(Raiz5,1),gray);
draw((Raiz5,0)--(Raiz5,1),gray);
draw((0,1)--(Raiz5,1),gray);
draw(arc((0,0),Raiz6,0,28),magenta);

// Los puntos
dot((0,0),3bp+black);
dot((Raiz5,1),3bp+black);
pair A=(Raiz5,0); dot(A,4bp+blue); label("$\sqrt{5}$",A,S);
pair B=(0,1); dot(B,4bp+blue); label("$1$",B,W);
pair C=(Raiz6,0); dot(C,4bp+deepgreen); label("$\sqrt{6}$",C,S);
pair D=(1,0); dot(D,3bp+blue); label("$1$",D,S);
pair E=(2,0); dot(E,3bp+blue); label("$2$",E,S);
pair F=(0,0); dot(F,3bp+blue); label("$0$",F,S);

// Longitud de la hipotenusa
label("$\sqrt{6}$",(1,0.5),N);
