//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Representar la resolución 2
// Fecha:    X.7.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Función que marca un punto
void Marca(real Num, string Tex, pen Color)
    {
    dot((Num,0),4bp+Color);
    label(Tex,(Num,0),S);
    }

// El eje de abscisas
draw((-2.05,0) -- (-0.95,0));

// La semirrecta
draw((-1,0) -- (-2,0.15));

// Arcos
real alfa=180-aTan(0.15);
for ( int i=1 ; i<8 ; ++i )
    {
    draw(arc((-1,0),i*0.14,alfa+3/i,alfa-3/i),gray);
    label('('+string(i)+')',(-1,0)+i*0.14*dir(alfa+3/i),1.5*N,fontsize(8pt));
    }

// Líneas auxiliares
draw((-2,0)--(-1,0)+0.98*dir(alfa),magenta);
draw((-1.43,0)--(-1,0)+0.42*dir(alfa),magenta);

// Los puntos
Marca(-2,"$-2$",blue);
Marca(-1,"$-1$",blue);
Marca(-1.43,"$-\frac{10}{7}$",deepgreen);
