//---------------------------------------------------------------
// Fichero:  segmento.asy
// Objetivo: Dibujar un segmento dividido según la proporción áurea
// Fecha:    M.30.1.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los puntos
real phi=(1+sqrt(2))/2;
pair A=(0,0), B=(phi,0), C=(1+phi,0);
pen FormatoPunto=2bp+blue;
draw(A--C);
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);

// La separación entre las flechas y el objeto
real Separacion = 0.1;

// Las flechas
draw(A+(0,-Separacion) -- B+(0,-Separacion),
     darkgreen+0.25bp, Arrows(2bp), Bars(1mm));
draw(B+(0,-Separacion) -- C+(0,-Separacion),
     darkgreen+0.25bp, Arrows(2bp), Bars(1mm));
draw(A+(0,Separacion) -- C+(0,Separacion),
     darkgreen+0.25bp, Arrows(2bp), Bars(1mm));

// Los nombres
pen FormatoTexto=fontsize(8pt);
label("a+b", (A+C)/2, 3N, FormatoTexto);
label("a", (A+B)/2, 3S, FormatoTexto);
label("b", (B+C)/2, 2.5S, FormatoTexto);

