//---------------------------------------------------------------
// Fichero:  simetricaAB.asy
// Objetivo: Representar A∆B
// Fecha:    V.23.2.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// El conjunto universal
path U=box((-2,-1.5),(2,1.8));
draw(U);

// La separación desde el (0,0)
real Sep=0.65;

// El conjunto A
path A=shift(0,Sep)*unitcircle;
draw(A,gray);

// El conjunto B
path B=shift(Sep*dir(210))*unitcircle;
draw(B,gray);

// El conjunto C
path C=shift(Sep*dir(-30))*unitcircle;
draw(C,gray);

// La diferencia simétrica
filldraw(A^^B,gray+evenodd,black);
