//---------------------------------------------------------------
// Fichero:  triangulopascalsimetrico.asy
// Objetivo: Representar la simetría del triángulo de Pascal
// Fecha:    L.15.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.75cm);

// Función que escribe un valor en un hexágono
void Escribe(path H, int F, int C)
    {
    pair T=(point(H,0)+point(H,3))/2;
    label(string(choose(F,C)),T,fontsize(14pt));
    }

// El número de líneas que vamos a generar
int n=6;

// Desplazamientos
real DespHorz=sqrt(3);
real DespVert=-1.5;

// El hexágono base
path Hexagono=rotate(30)*polygon(6);

// Las filas
real Izq=0;
pen Color;
for ( int Fil=0 ; Fil<n ; ++Fil )
    {
    Izq=-DespHorz*Fil/2;
    // Las columnas
    for ( int Col=0 ; Col<Fil+1 ; ++Col )
        {
        path Hex=shift(Izq,Fil*DespVert)*Hexagono;
        Escribe(Hex,Fil,Col);
        draw(Hex,gray+0.5bp);
        path Hex=shift(Izq,Fil*DespVert)*scale(0.9)*Hexagono;
        int Num=choose(Fil,Col);
        if      ( Num == 1 )  { Color = red; }
        else if ( Num >=2 & Num<=5 )  { Color = heavygreen; }
        else    { Color = blue; }
        draw(Hex,Color+0.5bp);
        Izq += DespHorz;
        }
    }

