//---------------------------------------------------------------
// Fichero:  triangulopascalpotencias.asy
// Objetivo: Representar el triángulo de Pascal con potencias
// Fecha:    M.26.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.75cm);

// Grosor de las líneas
defaultpen(1);

// Función que escribe un valor en un hexágono
void Escribe(path H, int F, int C)
    {
    pair T=(point(H,0)+point(H,3))/2;
    label(string(choose(F,C)),T,fontsize(14pt));
    }

// El número de líneas que vamos a generar
int n=6;

// Desplazamientos
real DespHorz=sqrt(3);
real DespVert=-1.5;

// La abscisa final de todas las líneas
real Fin=n*DespHorz/2+3;

// El hexágono base
path Hexagono=rotate(30)*polygon(6);

// Las filas
real Izq=0;
for ( int Fil=0 ; Fil<n ; ++Fil )
    {
    Izq=-DespHorz*Fil/2;
    // Las columnas
    for ( int Col=0 ; Col<Fil+1 ; ++Col )
        {
        path Hex=shift(Izq,Fil*DespVert)*Hexagono;
        Escribe(Hex,Fil,Col);
        draw(Hex);
        Izq += DespHorz;
        }
    // La potencia
    pair Derecha=(Fin,Fil*DespVert);
    draw((1.25+Fil*DespHorz/2,Fil*DespVert)--Derecha-(0.75,0),
          1bp+blue,Arrow(5bp),BeginBar(3bp));
    label("$2^"+string(Fil)+"$",Derecha);
    }

