//---------------------------------------------------------------
// Fichero:  cuadrados.asy
// Objetivo: Dar un ejemplo de cuadrados colocados
// Fecha:    X.10.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2.5cm);

// Colores disponibles
pen[] Color={blue, yellow, heavygreen, red};

// Función que baraja el conjunto de colores
void Baraja()
    {
    pen Tmp;
    int j;
    for ( int i=0 ; i<Color.length ; ++i )
        {
        j = floor(unitrand()*Color.length);
        Tmp=Color[i];
        Color[i]=Color[j];
        Color[j]=Tmp;
        }
    }

// El cuadrado base
path Cuadrado=polygon(4);

// Los cuatro triángulos en que se divide
pair P0=point(Cuadrado,0), P1=point(Cuadrado,1);
pair P2=point(Cuadrado,2), P3=point(Cuadrado,3);
path T1=(0,0) -- P0 -- P1 -- cycle;
path T2=(0,0) -- P1 -- P2 -- cycle;
path T3=(0,0) -- P2 -- P3 -- cycle;
path T4=(0,0) -- P3 -- P0 -- cycle;

// Dibujamos
real Desp=1.5;
for ( int i=0 ; i<2 ; ++i )
    {
    for ( int j=0 ; j<2 ; ++j )
        {
        Baraja();
        fill(shift(i*Desp,j*Desp)*T1,Color[0]);
        fill(shift(i*Desp,j*Desp)*T2,Color[1]);
        fill(shift(i*Desp,j*Desp)*T3,Color[2]);
        fill(shift(i*Desp,j*Desp)*T4,Color[3]);
        draw(shift(i*Desp,j*Desp)*Cuadrado,black+1bp);
        }
    }
