//---------------------------------------------------------------
// Fichero:  serieT.asy
// Objetivo: Dar varios ejemplos de baldosa serie T
// Fecha:    L.8.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.5cm);

// Iniciamos el generador de números aleatorios
srand(1);

// Colores disponibles
pen[] Color={blue, yellow, heavygreen, red, gray, purple};

// Función que baraja el conjunto de colores
void Baraja()
    {
    pen Tmp;
    int j;
    for ( int i=0 ; i<Color.length ; ++i )
        {
        j = floor(unitrand()*Color.length);
        Tmp=Color[i];
        Color[i]=Color[j];
        Color[j]=Tmp;
        }
    }

// El triángulo base
path Triangulo=polygon(3);

// Los cuatro triángulos en que se divide
pair P0=point(Triangulo,0), P1=point(Triangulo,1), P2=point(Triangulo,2);
pair M0=(P0+P1)/2, M1=(P1+P2)/2, M2=(P2+P0)/2;
path T1=P0 -- M0 -- M2 -- cycle;
path T2=M0 -- P1 -- M1 -- cycle;
path T3=M1 -- P2 -- M2 -- cycle;
path T4=M0 -- M1 -- M2 -- cycle;

// Las baldosas
int Base=0;
for ( int i=0 ; i<5 ; ++i )
    {
    Baraja();
    fill(shift(Base,0)*T1,Color[0]);
    fill(shift(Base,0)*T2,Color[1]);
    fill(shift(Base,0)*T3,Color[2]);
    fill(shift(Base,0)*T4,Color[3]);
    draw(shift(Base,0)*Triangulo,black+1bp);
    Base += 2;
    }
