//---------------------------------------------------------------
// Fichero:  go.asy
// Objetivo: Mostrar varios tablero de go con datos
// Fecha:    D.7.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(0.4);

// El tablero
string Nom[] = {'a','b','c','d','e','f','g','h', 'i', 'j', 'k', 'l', 'm', 'n',
                'o', 'p', 'q', 'r', 's'};
pen Formato = fontsize(4pt)+Helvetica(series="b",shape="n");
pen Color;
for ( int i=0 ; i<19 ; ++i )
    {
    // Los nombres de las filas y columnas
    label(Nom[i],(i,-0.85),N,Formato);
    label(string(i+1),(-0.4,i),W,Formato);

    // Las líneas
    draw((i,0)--(i,18));
    draw((0,i)--(18,i));
    }
draw(box((0,0),(18,18)),black+1bp);

// Un camino válido
pair Punto=(0,18);
guide Camino=Punto;
int Abajo=18, Derecha=18;
srand(5);
while ( Abajo+Derecha > 0 )
    {
    if ( Abajo == 0 )
        {
        Punto += (1,0);
        Derecha -=1;
        }
    else if ( Derecha == 0 )
        {
        Punto += (0,-1);
        Abajo -= 1;
        }
    else if ( unitrand() < 0.5 )
        {
        Punto += (0,-1);
        Abajo -= 1;
        }
    else
        {
        Punto += (1,0);
        Derecha -=1;
        }
    Camino = Camino -- Punto;
    }
draw(Camino,deepgreen+1.5bp);

// Las posiciones inicial y final
path Piedra=scale(0.25)*unitcircle;
fill(shift(0,18)*Piedra,blue);
fill(shift(18,0)*Piedra,blue);
