//---------------------------------------------------------------
// Fichero:  enunciado5.asy
// Objetivo: Representar el enunciado 5
// Fecha:    M.16.4.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Función que escribe un valor en un hexágono
void Escribe(path H, int F, int C)
    {
    pair T=(point(H,0)+point(H,3))/2;
    label(string(choose(F,C)),T,fontsize(16pt));
    }

// Desplazamientos
real DespHorz=sqrt(3);
real DespVert=-1.5;

// El hexágono base
path Hexagono=rotate(30)*polygon(6);

// Las filas
real Izq=0;
for ( int Fil=13 ; Fil<17 ; ++Fil )
    {
    Izq=DespHorz*(Fil+13)/2;
    // Las columnas
    for ( int Col=Fil-8 ; Col<9 ; ++Col )
        {
        path Hex=shift(Izq,Fil*DespVert)*Hexagono;
        if ( Fil==13 & Col==5 | Fil==13 & Col==8 | Fil==16 )
            { Escribe(Hex,Fil,Col); }
        draw(Hex,black+1bp);
        Izq += DespHorz;
        }
    }

