//---------------------------------------------------------------
// Fichero:  grafica.asy
// Objetivo: Representación de las gráficas de log2(x) y 2^x
// Fecha:    X.11.12.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -1.5, Xmax = 4.5, Ymin = -1.5, Ymax = 4.5;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), gray);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica del logaritmo
real F(real x) { return (log(x)/log(2)); }
path Grafica=graph(F,0.35,Xmax,n=100);
draw(Grafica);

// La gráfica de la exponencial
real F(real x) { return 2^x; }
path Grafica=graph(F,Xmin,2.15,n=200);
draw(Grafica);

// Algunas abscisas
real Abs[]={-1, 0.5, 1, 2, 4};
real Desp=0.1;
for ( int i=0 ; i<Abs.length ; ++i )
    {
    draw((Abs[i],-Desp)--(Abs[i],Desp),gray);
    label(string(Abs[i]),(Abs[i],0),2S);
    }

// Algunas ordenadas
real Ord[]={-1, 0.5, 1, 2, 4};
real Desp=0.1;
for ( int i=0 ; i<Ord.length ; ++i )
    {
    draw((-Desp,Ord[i])--(Desp,Ord[i]),gray);
    label(string(Ord[i]),(0,Ord[i]),2W);
    }

// Los puntos
real Grosor=5bp;
dot((1,0),deepgreen+Grosor);
dot((0,1),deepgreen+Grosor);
dot((2,1),red+Grosor);
dot((1,2),red+Grosor);
dot((4,2),blue+Grosor);
dot((2,4),blue+Grosor);
dot((0.5,-1),orange+Grosor);
dot((-1,0.5),orange+Grosor);

// La bisectriz
pen Punteado = linetype(new real[] {2,2});
draw((-1,-1) -- (4.2,4.2), Punteado+gray);

// Las flechas
pair Desp=(0.1,-0.1);
draw(((1,0)-Desp)--((0,1)+Desp),heavygray,Arrows(3bp));
draw(((2,1)-Desp)--((1,2)+Desp),heavygray,Arrows(3bp));
draw(((4,2)-Desp)--((2,4)+Desp),heavygray,Arrows(3bp));
draw(((0.5,-1)-Desp)--((-1,0.5)+Desp),heavygray,Arrows(3bp));
