//---------------------------------------------------------------
// Fichero:  p.asy
// Objetivo: Representar la función p
// Fecha:    M.17.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Símbolos
usepackage("amssymb");

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// La elipse general
path Elipse=scale(1,2)*unitcircle;

// Formatos del texto
pen FormatoNombre=fontsize(12pt)+Bookman(series="m",shape="n");
pen Formato=fontsize(14pt);

// Posiciones horizontales
real xA=-1.5, xB=1.5, xFA=-1.1, xFB=1.1;

// Posiciones verticales
real y0=2.1, yF=2.4, y1=1.3, y2=0.4, y3=-0.5, y4=-1.3;

// Los conjuntos
draw(shift(xA,0)*Elipse);
draw(shift(xB,0)*Elipse);
label("B",(xA,y0),N,FormatoNombre);
label("A",(xB,y0),N,FormatoNombre);

// La función
label("p",(0,y0),3*N,FormatoNombre);

// Los elementos
label("$\bigstar$",(xA,y1),Formato);
label("$\blacksquare$",(xA,y2),Formato);
label("$\clubsuit$",(xA,y3),Formato);
label("$\blacktriangle$",(xA,y4),Formato);
label("$\alpha$",(xB,y1),Formato);
label("$\beta$",(xB,y2),Formato);
label("$\gamma$",(xB,y3),Formato);
label("$\delta$",(xB,y4),Formato);

// Las flechas
draw((xFA,yF)--(xFB,yF),blue,Arrow(SimpleHead,5bp));
draw((xFA,y1)--(xFB,y3),blue,Arrow(SimpleHead,5bp));
draw((xFA,y2)--(xFB,y1),blue,Arrow(SimpleHead,5bp));
draw((xFA,y3)--(xFB,y2),blue,Arrow(SimpleHead,5bp));
draw((xFA,y4)--(xFB,y4),blue,Arrow(SimpleHead,5bp));
