//---------------------------------------------------------------
// Fichero:  h.asy
// Objetivo: Representar la relación h
// Fecha:    M.17.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Símbolos
usepackage("amssymb");

// fontsize()
include fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// La elipse general
path Elipse=scale(1,2)*unitcircle;

// Formatos del texto
pen FormatoNombre=fontsize(12pt)+Bookman(series="m",shape="n");
pen Formato=fontsize(14pt);

// Posiciones horizontales
real xA=-1.5, xB=1.5, xFA=-1.1, xFB=1.1;

// Posiciones verticales
real y0=2.1, yF=2.4, y1=1.3, y2=0.4, y3=-0.5, y4=-1.3;

// Los conjuntos
draw(shift(xA,0)*Elipse);
draw(shift(xB,0)*Elipse);
label("A",(xA,y0),N,FormatoNombre);
label("B",(xB,y0),N,FormatoNombre);

// La función
label("h",(0,y0),3*N,FormatoNombre);

// Los elementos
label("$\alpha$",(xA,y1),Formato);
label("$\beta$",(xA,y2),Formato);
label("$\gamma$",(xA,y3),Formato);
label("$\delta$",(xA,y4),Formato);
label("$\bigstar$",(xB,y1),Formato);
label("$\blacksquare$",(xB,y2),Formato);
label("$\clubsuit$",(xB,y3),Formato);
label("$\blacktriangle$",(xB,y4),Formato);

// Las flechas
draw((xFA,yF)--(xFB,yF),blue,Arrow(SimpleHead,5bp));
draw((xFA,y1)--(xFB,y2),blue,Arrow(SimpleHead,5bp));
draw((xFA,y2)--(xFB,y3+0.1),blue,Arrow(SimpleHead,5bp));
draw((xFA,y4)--(xFB,y3-0.1),blue,Arrow(SimpleHead,5bp));
