//---------------------------------------------------------------
// Fichero:  noinyectiva.asy
// Objetivo: Mostrar lo que ocurre con una función no inyectiva
// Fecha:    X.9.10.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -7, Xmax = 7, Ymin = 0, Ymax = 4, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de texto
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
draw((0,Ymin-Extra) -- (0,Ymax+Extra), black);

// El eje de abscisas
draw((Xmin-Extra,0) -- (Xmax+Extra,0), black);

// Una recta horizontal
draw ((Xmin,2) -- (Xmax,2), deepgreen);

// La gráfica
real F(real x) { return (0.08*x^2); }
path Grafica=graph(F,Xmin,Xmax,n=100);
draw(Grafica,linewidth(2bp)+blue);

// Los puntos de corte
dot((5,2),red+4pt);
dot((-5,2),red+4pt);

// El punto del eje de ordenadas
dot((0,2),deepgreen+4pt);
dot((0,2),white+2pt);

// Los puntos del eje de abscisas
dot((5,0),magenta+4pt);
dot((-5,0),magenta+4pt);

// Las flechas
draw((5,1.8) -- (5,0.2), gray, Arrow(HookHead,1.5bp));
draw((-5,1.8) -- (-5,0.2), gray, Arrow(HookHead,1.5bp));
