//---------------------------------------------------------------
// Fichero:  a12.asy
// Objetivo: Función y=1.2^x
// Fecha:    M.1.10.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 3, Ymin = -1, Ymax = 2, Extra = 0.1;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(4pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
real F(real x) { return (1.2^x); }
path Grafica=graph(F,Xmin,Xmax,n=100);
draw(Grafica);

// Dos puntos
dot((0,1),deepgreen+4bp);
dot((1,F(1)),red+4bp);
