//---------------------------------------------------------------
// Fichero:  mayor1.asy
// Objetivo: Función exponencial con a>1
// Fecha:    L.9.12.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -0.5, Ymax = 4;

// Grosor de las líneas
defaultpen(1);

// El eje de ordenadas
draw((0,Ymin) -- (0,Ymax), gray);

// El eje de abscisas
draw((Xmin,0) -- (Xmax,0), gray);

// La gráfica
real F(real x) { return (1.4^x); }
path Grafica=graph(F,Xmin,Xmax,n=200);
draw(Grafica);

// Dos puntos
dot((0,1),deepgreen+4bp);
dot((1,F(1)),red+4bp);
