//---------------------------------------------------------------
// Fichero:  grafica.asy
// Objetivo: Mostrar la gráfica de la función
// Fecha:    M.24.12.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 4, Ymin = -1, Ymax = 3, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(8pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-3,-1) -- (-1,1));
draw((-1,2) -- (2,-1));
draw((2,1) -- (4,3));

// Los puntos especiales
dot((-3,-1), 5bp+black);
dot((-3,-1), 3bp+white);
dot((-1,1), 5bp+black);
dot((-1,1), 3bp+white);
dot((-1,2), 5bp+black);
dot((-1,2), 3bp+white);
dot((2,-1), 5bp+black);
dot((2,1), 5bp+black);
dot((2,1), 3bp+white);
