//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Mostrar la solución 4
// Fecha:    L.10.2.2025
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// xaxis(), yaxis()
import graph;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Dimensiones de los ejes
real Xmin = -3, Xmax = 4, Ymin = -1, Ymax = 3, Extra = 0.25;

// Grosor de las líneas
defaultpen(1);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=blue);

// Formato de texto de los dos ejes
pen FormatoTexto = blue+fontsize(10pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), gray);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), gray);

// La gráfica
draw((-3,-1) -- (-1,1));
real F(real x) { return (x^2); }
path Grafica=graph(F,-1,1,n=100);
draw(Grafica);
real F(real x) { return (-x^2+4x-1); }
path Grafica=graph(F,1,3,n=100);
draw(Grafica);
draw((3,1) -- (4,1));

// Los puntos especiales
dot((-3,-1), 5bp+black);
dot((-3,-1), 3bp+white);
dot((1,1), 5bp+black);
dot((1,1), 3bp+white);
dot((1,2), 5bp+black);
dot((3,2), 5bp+black);
dot((3,2), 3bp+white);
dot((3,1), 5bp+black);
dot((4,1), 5bp+black);
dot((4,1), 3bp+white);
