//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar el ejemplo 2
// Fecha:    X.21.8.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph(), xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 4, Ymin = -4, Ymax = 4, Extra = 0.5;

// Grosor de las líneas
defaultpen(0.5);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=black);

// Formato de texto de los dos ejes
pen FormatoTexto = black+fontsize(3pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), black);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), black);

// Las gráficas
real F1(real x) { return (-4/x); }
path Grafica=graph(F1,Xmin,-1,n=100);
draw(Grafica,blue+1bp);
path Grafica=graph(F1,1,Xmax,n=100);
draw(Grafica,blue+1bp);
real F2(real x) { return (2*x); }
path Grafica=graph(F2,Xmin+2,Xmax-2,n=100);
draw(Grafica,heavygreen+1bp);
