//---------------------------------------------------------------
// Fichero:  ejemplo1.asy
// Objetivo: Representar el ejemplo 1
// Fecha:    X.21.8.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// graph(), xaxis(), yaxis()
import graph;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Dimensiones de los ejes
real Xmin = -4, Xmax = 3, Ymin = -4, Ymax = 5, Extra = 0.5;

// Grosor de las líneas
defaultpen(0.5);

// Formato de marcas de los dos ejes
ticks FormatoTicks = Ticks(Step=1, NoZero, Size=0.5mm, pTick=black);

// Formato de texto de los dos ejes
pen FormatoTexto = black+fontsize(3pt);

// El eje de ordenadas
yaxis(ymin=Ymin, ymax=Ymax, FormatoTexto, FormatoTicks);
draw((0,Ymin-Extra) -- (0,Ymax+Extra), black);

// El eje de abscisas
xaxis(xmin=Xmin, xmax=Xmax, FormatoTexto, FormatoTicks);
draw((Xmin-Extra,0) -- (Xmax+Extra,0), black);

// Las gráficas
real F1(real x) { return (x^2-4); }
path Grafica=graph(F1,Xmin+0.9,Xmax,n=100);
draw(Grafica,blue+1bp);
real F2(real x) { return (-2*x-1); }
path Grafica=graph(F2,Xmin+0.8,Xmax-1.5,n=100);
draw(Grafica,heavygreen+1bp);

// Los puntos de corte
dot((-3,5),red+2bp);
dot((1,-3),red+2bp);
