//---------------------------------------------------------------
// Fichero:  OM2019-3.asy
// Objetivo: Representar el dibujo
// Fecha:    M.16.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Radios de las dos circunferencias
real Rg = 72;
real Rp = 61;

// Grosor de las líneas
defaultpen(1);

// Dos diámetros grandes
pen Punteado = linetype(new real[] {2,2});
draw((-Rg,0) -- (Rg,0), Punteado);
draw((0,-Rg) -- (0,Rg), Punteado);

// Los tres datos como segmentos
pen AzulGrueso = blue+2bp+squarecap;
draw((0,2*Rp-Rg) -- (0,Rg), AzulGrueso);
draw((60,0) -- (Rg,0), AzulGrueso);
draw((-60,0) -- (-Rg,0), AzulGrueso);

// Los tres datos como números
pen Fuente = fontsize(6pt);
label("22", (8,Rp), Fuente);
label("12", (65,6), Fuente);
label("12", (-65,6), Fuente);

// La circunferencia grande
draw(circle((0,0),Rg));

// La circunferencia pequeña
draw(circle((0,Rp-Rg),Rp));
