//---------------------------------------------------------------
// Fichero:  poligonos.asy
// Objetivo: Dibujar dos polígonos adyacentes
// Fecha:    D.1.9.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El polígono de 10 lados
path P10=rotate(18)*polygon(10);
draw(P10,blue);
pair M10=(point(P10,1)+point(P10,2))/2;

// El polígono de 15 lados
path P15=rotate(6)*scale(sin(18)/sin(12))*polygon(15);
pair M15=(point(P15,10)+point(P15,11))/2;
P15=shift(M10-M15)*P15;
draw(point(P15,9) -- point(P15,10) -- point(P15,11) -- point(P15,12), red);

// El lado común
draw(point(P10,1) -- point(P10,2), deepgreen);

// El ángulo
pair A=point(P10,0), V=point(P10,1), B=point(P15,12);
markangle("$60^\circ$", radius=4mm, A, V, B, 0.5bp+black);
