#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  casquete.py
# Objetivo: Da el volumen de un casquete esférico
#           a partir de la altura y el radio de la esfera
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    J.5.10.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# pi
import math

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Altura = float(sys.argv[1])
Radio = float(sys.argv[2])

# Mostramos los datos
print 'Altura:', Altura
print 'Radio de la esfera:', Radio

# Cuadrado del radio de la base
Cuadrado = Radio**2 - (Altura-Radio)**2

# El volumen
Volumen = math.pi*Altura*(3*Cuadrado+Altura**2)/6

# Mostramos el resultado
print 'Volumen:', Volumen
