//---------------------------------------------------------------
// Fichero:  relacion3D.asy
// Objetivo: Mostrar en 3D la relación en un segmento esférico
// Fecha:    L.25.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// La figura plana
real Altura1=0.6, Altura2=-0.8;
real a=sqrt(1-Altura1^2), b=sqrt(1-Altura2^2);
path3 Arco=arc((0,0,0), (a,0,sqrt(1-a^2)), (b,0,-sqrt(1-b^2)), Y);

// El cuerpo de revolución
draw(surface(revolution(Arco,Z)),lightgray+opacity(.5));
draw(circle((0,0,sqrt(1-a^2)),a),1bp+black);
draw(surface(circle((0,0,sqrt(1-a^2)),a)),lightgray+opacity(.5));
draw(circle((0,0,-sqrt(1-b^2)),b),1bp+black);
draw(surface(circle((0,0,-sqrt(1-b^2)),b)),lightgray+opacity(.5));

// Los puntos
triple A=(0,0,0), B=Altura1*Z, C=rotate(35,Z)*(0,a,Altura1);
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);

// Las líneas
draw(A -- B -- C -- cycle, 2bp+red);

// El triángulo
draw(surface(A -- B -- C -- cycle),green);
