//---------------------------------------------------------------
// Fichero:  figura6.asy
// Objetivo: Mostrar en 2D la clave de la figura 6
// Fecha:    L.25.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,3), C=(0,3), D=(0,abs(B));

// El ángulo recto
markrightangle(A, C, B, 2mm, 0.5bp+blue);

// Los segmentos
draw(D -- A -- B -- C);

// Las línea auxiliar
pair Delta=(-0.2,0);
pen Formato=darkgreen+0.2mm;
draw(A+Delta -- D+Delta,Formato);

// Los textos
pen FormatoTexto=fontsize(8pt)+blue;
label("$r$", (A+B)/2, SE, FormatoTexto);
label("$r$", (A+D)/2+Delta, W, FormatoTexto);
label("$s$", (B+C)/2, N, FormatoTexto);
label("$h$", (C+D)/2, E, FormatoTexto);
label("$r-h$", (A+C)/2, E, FormatoTexto);

// Los puntos
dot(A,2bp+red);
dot(B,2bp+red);
dot(C,2bp+red);
dot(D,2bp+red);
