#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  troncocono.py
# Objetivo: Da el área y el volumen de un tronco de cono recto
#           a partir de la altura y los radios de las bases
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    L.18.9.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# sqrt(), pi
import math

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Altura = float(sys.argv[1])
RadioMayor = float(sys.argv[2])
RadioMenor = float(sys.argv[3])

# Mostramos los datos
print 'Altura:', Altura
print 'Radio mayor:', RadioMayor
print 'Radio menor:', RadioMenor

# La generatriz del tronco
Generatriz = math.sqrt(Altura**2+(RadioMayor-RadioMenor)**2)

# El área
Area1 = RadioMayor**2 + RadioMenor**2 + (RadioMayor+RadioMenor)*Generatriz
Area2 = math.pi*Area1

# Las alturas
AlturaMenor = Altura*RadioMenor / (RadioMayor-RadioMenor)
AlturaMayor = Altura + AlturaMenor

# El volumen
Volumen1 = (RadioMayor**2*AlturaMayor-RadioMenor**2*AlturaMenor)/3
Volumen2 = math.pi*Volumen1

# Mostramos el resultado
print 'Área:', Area1, Area2
print 'Volumen:', Volumen1, Volumen2
