//---------------------------------------------------------------
// Fichero:  triangulos.asy
// Objetivo: Mostrar los triángulos semejantes
// Fecha:    M.12.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4cm);

// Punto de proyección
currentprojection=orthographic((5,2,2),Z);

// Datos de la figura plana que genera el tronco de cono
real Radio1=3, Radio2=2, Altura=2.5;

// Datos auxiliares
real x=Radio2*Altura/(Radio1-Radio2);

// La figura plana que genera el cono
path3 Trapecio = (0,0,0) -- (Radio1,0,0) -- (0,0,Altura+x);

// El cuerpo de revolución
draw(surface(revolution(Trapecio,Z)),lightgray+opacity(.6));
draw(circle((0,0,0),Radio1),1bp+black);
draw(circle((0,0,Altura),Radio2),1bp+black);

// La altura
triple S1=(0,0,0), S2=(0,0,Altura+x);
dot(S1, 3bp+black);
dot(S2, 3bp+black);
draw(S1 -- S2, 2bp+red);

// Los radios de las bases
triple S3=(0,Radio1,0);
triple S4=(0,Radio2,Altura);
triple S5=(0,0,Altura);
dot(S3, 3bp+black);
dot(S4, 3bp+black);
dot(S5, 3bp+black);
draw(S1 -- S3, 2bp+red);
draw(S5 -- S4, 2bp+red);

// La generatriz grande
draw(S2 -- S3, 2bp+red);

// El triańgulo
draw(surface(S1 -- S2 -- S3 -- cycle),green);
