//---------------------------------------------------------------
// Fichero:  desarrollo.asy
// Objetivo: Representar el desarrollo plano del tronco de cono
// Fecha:    L.11.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Datos de la figura plana que genera al tronco
real r=3, s=2, h=2.5;

// Datos auxiliares
real x=s*h/(r-s);
real rp=sqrt(x^2+s^2);
real g=sqrt(h^2+(r-s)^2);
real rg=rp+g;
real Ang=180*s/rp;
pair A=rp*dir(270-Ang), B=rp*dir(270+Ang);
pair C=rg*dir(270-Ang), D=rg*dir(270+Ang);
real Correccion=(A.y-x-h)/2;

// Los desplazamientos
pair DesplIzq=(C.x-s-1,Correccion);
pair DesplDer=(D.x+r+1,Correccion);

// Los dos círculos
draw (shift(DesplIzq)*circle((0,0),s));
draw (shift(DesplDer)*circle((0,0),r));

// El trapecio circular
draw(arc((0,0),A,B));
draw(arc((0,0),C,D));
draw(A--C);
draw(B--D);

// Los textos
pen FormatoTexto=fontsize(12pt)+blue;
real Inc=0.4;
label("Base",shift(DesplIzq)*(0,Inc),FormatoTexto);
label("menor",shift(DesplIzq)*(0,-Inc),FormatoTexto);
label("Base",shift(DesplDer)*(0,Inc),FormatoTexto);
label("mayor",shift(DesplDer)*(0,-Inc),FormatoTexto);
label("Superficie",(0,Correccion-3.5*Inc),FormatoTexto);
label("lateral",(0,Correccion-5.5*Inc),FormatoTexto);
