//---------------------------------------------------------------
// Fichero:  lateral.asy
// Objetivo: Resaltar la superficie lateral
// Fecha:    D.10.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.3cm);

// Punto de proyección
currentprojection=orthographic((5,2,2),Z);

// Datos de la figura plana
real Radio1=3, Radio2=2, Altura=2.5;

// La figura plana
path3 Trapecio = (Radio1,0,0) -- (Radio2,0,Altura);

// El cuerpo de revolución
draw(surface(revolution(Trapecio,Z)),red+opacity(.6));
draw(circle((0,0,0),Radio1),1bp+black);
draw(circle((0,0,Altura),Radio2),1bp+black);
draw(surface(circle((0,0,Altura),Radio2)),white);
