//---------------------------------------------------------------
// Fichero:  resultado.asy
// Objetivo: Mostrar el resultado del corte
// Fecha:    S.23.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// revolution()
import solids;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(0,3cm);

// Punto de proyección
currentprojection = orthographic(50,50,25);

// Datos de la figura
real Radio=4, Altura=7;

// La figura plana que genera el tronco de cono
path3 Trapecio = (Radio,0,0) -- (16/7,0,3);

// El cuerpo de revolución
draw(surface(revolution(Trapecio,Z)),lightgray+opacity(.5));
draw(surface(circle((0,0,3),16/7)),lightgray);
draw(circle((0,0,3),16/7),1bp+black);
draw(circle((0,0,0),Radio),1bp+black);

// Punto invisible
dot(Z*Altura,white);
