//---------------------------------------------------------------
// Fichero:  triangulos-3D.asy
// Objetivo: Mostrar en 3D los dos triángulos
// Fecha:    J.7.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.2cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(14.7,0), C=(0,22.7);

// El triángulo
draw(A -- B -- C -- cycle);

// La apotema corta
pair D=(0,8), E1=(9.53,8);
draw(D -- E1);

// Los textos
pen FormatoTexto=fontsize(8pt)+blue;
label("$8$", (A+D)/2, W, FormatoTexto);
label("$b$", (D+E1)/2, S, FormatoTexto);
label("$x$", (D+C)/2, W, FormatoTexto);
label("$a$", (A+B)/2, S, FormatoTexto);

// Marcamos el punto de división
dot(D,2bp+red);

// Marcamos los ángulos rectos
markrightangle(C, A, B, 2mm, 0.5bp+blue);
markrightangle(C, D, E1, 2mm, 0.5bp+blue);
