//---------------------------------------------------------------
// Fichero:  basemenor.asy
// Objetivo: Mostrar la base menor
// Fecha:    V.8.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(1.5cm);

// Grosor de las líneas
defaultpen(0.5);

// El hexagono
path Hexagono=polygon(6);

// El centro
pair C=(point(Hexagono,0)+point(Hexagono,3))/2;

// Dos vértices del triángulo rectángulo
pair A=(point(Hexagono,5)+point(Hexagono,0))/2;
pair B=point(Hexagono,0);

// El ángulo recto
markrightangle(C, A, B, 1mm, 0.5bp+blue);

// El triángulo
draw(A -- C -- B, blue);

// Dibujamos el hexagono
draw(Hexagono);

// Los puntos importantes
pen FormatoPunto=2bp+red;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);

// Los textos
pen FormatoTexto=deepgreen+fontsize(4pt)+Helvetica(series="m",shape="n");
label("11", (B+C)/2, NE, FormatoTexto);
label("5,5", (A+B)/2, S, FormatoTexto);
label("$b$", (A+C)/2, W, FormatoTexto);
