#!/usr/bin/python
# coding: utf-8

#--------------------------------------------------------------------
# Fichero:  tronco4.py
# Objetivo: Da el área y el volumen de un tronco de pirámide recto
#           de bases cuadradas a partir de la altura y los lados
# Autor:    Pedro Reina <pedro@pedroreina.net>
# Fecha:    V.8.9.2023
# Atención: solo se ha probado en Python 2.7
# Licencia: Dominio público
#           https://creativecommons.org/publicdomain/zero/1.0/
#--------------------------------------------------------------------

#------------------------------------------------
# Módulos
#------------------------------------------------

# Para leer la línea de órdenes
import sys

# sqrt(), pi
import math

#------------------------------------------------
# El programa
#------------------------------------------------

# Leemos los datos de la línea de órdenes
Altura = float(sys.argv[1])
LadoMayor = float(sys.argv[2])
LadoMenor = float(sys.argv[3])

# Mostramos los datos
print 'Altura:', Altura
print 'Lado mayor:', LadoMayor
print 'Lado menor:', LadoMenor

# Las apotemas de las bases
ApotemaMayor = LadoMayor/2
ApotemaMenor = LadoMenor/2

# La apotema del tronco
ApotemaTronco = math.sqrt(Altura**2+(ApotemaMayor-ApotemaMenor)**2)

# El área
Area = LadoMayor**2 + LadoMenor**2 + 2*ApotemaTronco*(LadoMayor+LadoMenor)

# Las alturas
AlturaMenor = Altura*ApotemaMenor / (ApotemaMayor-ApotemaMenor)
AlturaMayor = Altura + AlturaMenor

# El volumen
Volumen = (LadoMayor**2*AlturaMayor - LadoMenor**2*AlturaMenor)/3

# Mostramos el resultado
print 'Área:', Area
print 'Volumen:', Volumen
