//---------------------------------------------------------------
// Fichero:  triangulos-3D.asy
// Objetivo: Mostrar en 3D los dos triángulos
// Fecha:    J.7.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(3.5cm);

// Punto de proyección
currentprojection=orthographic(5,4,2);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de las bases
int N=4;

// -------------- Comienza el tronco

// Altura
real Altura=3;

// Las bases
real r2=sqrt(2);
path3 PoligonoBase1 = path3(rotate(5)*scale(12*r2)*polygon(N));
path3 PoligonoBase2 = shift(Altura*Z)*path3(rotate(5)*scale(8*r2)*polygon(N));

// Las caras del prisma
path3[] Caras={PoligonoBase1, PoligonoBase2};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase1,i)--point(PoligonoBase1,i+1)--
      point(PoligonoBase2,i+1)--point(PoligonoBase2,i)--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.3));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// -------------- Termina el tronco

// -------------- Comienza la pirámide

// El vértice superior
triple V=(0,0,9);

// Las caras del poliedro
path3[] Caras={PoligonoBase2};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase2,i)--point(PoligonoBase2,i+1)--V--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.3));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// -------------- Termina la pirámide

// -------------- Los segmentos

// La altura
triple S1=(0,0,0), S2=V;
dot(S1, 3bp+black);
dot(S2, 3bp+black);
draw(S1 -- S2, 2bp+red);

// Las apotemas de las bases
triple S3=(point(PoligonoBase1,1)+point(PoligonoBase1,2))/2;
triple S4=(point(PoligonoBase2,1)+point(PoligonoBase2,2))/2;
dot(S3, 3bp+black);
dot(S4, 3bp+black);
dot(Altura*Z, 3bp+black);
draw(Altura*Z -- S4, 2bp+red);
draw(S1 -- S3, 2bp+red);

// La apotema de las pirámides
draw(V -- S3, 2bp+red);

// El triańgulo
draw(surface(S1 -- S2 -- S3 -- cycle),green);
