//---------------------------------------------------------------
// Fichero:  altura-apotemas-3D.asy
// Objetivo: Mostrar en 3D la relación entre la altura y las tres
//           apotemas
// Fecha:    X.6.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(3.5cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de las bases
int N=5;

// Altura
real Altura=1;

// Las bases
path3 PoligonoBase1 = path3(rotate(5)*polygon(N));
path3 PoligonoBase2 = shift(Altura*Z)*scale3(0.75)*PoligonoBase1;

// Las caras del prisma
path3[] Caras={PoligonoBase1, PoligonoBase2};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase1,i)--point(PoligonoBase1,i+1)--
      point(PoligonoBase2,i+1)--point(PoligonoBase2,i)--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.7));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// El formato de los nombres
pen FormatoTexto=fontsize(10pt)+Helvetica(series="m",shape="n")+white;

// Una apotema del tronco
triple S1=(point(PoligonoBase1,0)+point(PoligonoBase1,1))/2;
triple S2=(point(PoligonoBase2,0)+point(PoligonoBase2,1))/2;
dot(S1, 3bp+black);
dot(S2, 3bp+black);
draw(S1 -- S2, 2bp+red);
label("m",(S1+S2)/2-.15Y,FormatoTexto);

// La altura
triple S4=(0,0,0), S3=(0,0,Altura);
dot(S3, 3bp+black);
dot(S4, 3bp+black);
draw(S3 -- S4, 2bp+red);
label("h",(S3+S4)/2+.15Y+0.1Z,FormatoTexto);

// Las apotemas de las bases
triple A=(0,0,0);
triple B=(point(PoligonoBase1,0)+point(PoligonoBase1,1))/2;
draw(A -- B, 2bp+red);
label("a",(A+B)/2+.25Y,FormatoTexto);
triple A=Altura*Z;
triple B=(point(PoligonoBase2,0)+point(PoligonoBase2,1))/2;
draw(A -- B, 2bp+red);
label("b",(A+B)/2-.15Y+.1Z,FormatoTexto);

// El trapecio
draw(surface(S1 -- S2 -- S3 -- S4 -- cycle),green);
