//---------------------------------------------------------------
// Fichero:  figura3.asy
// Objetivo: Mostrar la figura 3
// Fecha:    L.4.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Geometría 3D
import three;

// Obtendremos un archivo PNG
settings.outformat="png";
settings.render=6;

// Tamaño de la imagen
size(4.4cm);

// Punto de proyección
currentprojection=orthographic(5,4,3);

// Punto de luz
currentlight=light(10,0,10);

// Número de vértices de las bases
int N=5;

// La base es un polígono regular
path3 PoligonoBase = path3(rotate(5)*polygon(N));

// El vértice superior
triple V=(0,0,2);

// Altura
real Altura=1.3;

// Creamos un nuevo polígono
guide3 PoligonoNuevo;
for (int i=0; i<N; ++i)
    { PoligonoNuevo = PoligonoNuevo --
                     (point(PoligonoBase,i)+0.5*(V-point(PoligonoBase,i))); }
PoligonoNuevo = PoligonoNuevo -- cycle;

// Las caras del tronco
path3[] Caras={PoligonoBase, PoligonoNuevo};
for (int i=0; i<N; ++i)
    { Caras.push(point(PoligonoBase,i)--point(PoligonoBase,i+1)--
      point(PoligonoNuevo,i+1)--point(PoligonoNuevo,i)--cycle); }

// Dibujamos las caras
draw(surface(Caras),lightgray+opacity(.7));

// Dibujamos las aristas
draw(Caras,1.5bp+black);

// El vértice invisible
dot(V,white);
