//---------------------------------------------------------------
// Fichero:  dibujo.asy
// Objetivo: Dibujar el triángulo del enunciado
// Fecha:    V.1.9.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// fontsize()
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices del triángulo
real m=13.15, n=19.07;
pair A=(0,sqrt(m*n)), B=(-m,0), C=(n,0);

// La proyección del vértice sobre la hipotenusa
pair Q=(0,0);

// El triángulo
draw(A -- Q, blue);
draw(A -- B -- C -- cycle);

// Los puntos
pen FormatoPunto=3bp+red;
dot(A,FormatoPunto);
dot(B,FormatoPunto);
dot(C,FormatoPunto);
dot(Q,FormatoPunto);

// Los segmentos
pen FormatoSegmento=blue+fontsize(6pt);
label("13,15", (B+Q)/2, N, FormatoSegmento);
label("19,07", (Q+C)/2, N, FormatoSegmento);
label("h", (A+Q)/2, E, FormatoSegmento);
label("c", (A+B)/2, NW, FormatoSegmento);
label("b", (A+C)/2, NE, FormatoSegmento);
label("a", (B+C)/2+2S, S, FormatoSegmento);
draw(shift(0,-1.5)*(B -- C), darkgreen+1bp);
