//---------------------------------------------------------------
// Fichero:  resolucion2.asy
// Objetivo: Dibujar la resolución 2
// Fecha:    V.28.7.2023
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El triángulo izquierdo
pair A1=(0,0), B1=(17,0), C1=(0,7);
draw(A1 -- B1 -- C1 -- cycle);

// El triángulo derecho
pair A2=(25,0), B2=(56.6,0), C2=(25,13);
draw(A2 -- B2 -- C2 -- cycle);

// Los ángulos
pen FormatoAngulo = 0.5bp+blue;
markrightangle(C1, A1, B1, 3mm, FormatoAngulo);
markrightangle(C2, A2, B2, 3mm, FormatoAngulo);

// Los lados
pen FormatoLado=10pt+blue;
label("17",(8.5,0),S,FormatoLado);
label("7",(0,3.5),W,FormatoLado);
label("13",(25,6.5),W,FormatoLado);
label("a",(7.5,3.5),NE,FormatoLado);
label("b",(40.8,0),S,FormatoLado);
label("x",(40,6.5),NE,FormatoLado);
